/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcontrol.ui.controller;

import de.rtb.pcon.model.AlertType;
import de.rtb.pcon.model.EnumIndexOutOfBoundsException;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentType;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class UiConvertHelper {
    private static final Logger logger = LoggerFactory.getLogger(UiConvertHelper.class);

    private UiConvertHelper() {
    }

    public static OffsetDateTime from(LocalDateTime from, ZoneId userTimeZone) {
        return ZonedDateTime.of(UiConvertHelper.truncateFrom((LocalDateTime)from), userTimeZone).toOffsetDateTime();
    }

    public static LocalDateTime truncateFrom(LocalDateTime uiFrom) {
        return uiFrom;
    }

    public static LocalDateTime truncateTo(LocalDateTime uiTo) {
        return uiTo;
    }

    public static OffsetDateTime to(LocalDateTime to, ZoneId userTimeZone) {
        return ZonedDateTime.of(UiConvertHelper.truncateTo((LocalDateTime)to), userTimeZone).toOffsetDateTime();
    }

    public static List<PaymentType> convertPaymentTypes(Collection<Integer> paymentTypeIntegers) {
        ArrayList<PaymentType> result = new ArrayList();
        if (paymentTypeIntegers == null || paymentTypeIntegers.isEmpty()) {
            result = Arrays.asList(PaymentType.values());
        } else {
            for (Integer intValue : paymentTypeIntegers) {
                try {
                    result.add(PaymentType.fromValue((Integer)intValue));
                }
                catch (EnumIndexOutOfBoundsException e) {
                    logger.warn("Cannot convert value '{}' to PaymentType. Value ignored.", (Object)intValue);
                }
            }
        }
        return result;
    }

    public static List<PaymentReason> convertPaymentReasons(Collection<Integer> paymentReasonIntegers) {
        ArrayList<PaymentReason> result = new ArrayList();
        if (paymentReasonIntegers == null || paymentReasonIntegers.isEmpty()) {
            result = Arrays.asList(PaymentReason.values());
        } else {
            for (Integer intValue : paymentReasonIntegers) {
                try {
                    result.add(PaymentReason.fromValue((Integer)intValue));
                }
                catch (EnumIndexOutOfBoundsException e) {
                    logger.warn("Cannot convert value '{}' to PaymentReason. Value ignored.", (Object)intValue);
                }
            }
        }
        return result;
    }

    public static Collection<AlertType> convertAlertTypesNames(Collection<String> alertTypeNames) {
        Collection<Object> result;
        if (alertTypeNames == null || alertTypeNames.isEmpty()) {
            result = Arrays.asList(AlertType.values());
        } else {
            result = new HashSet();
            for (String valueName : alertTypeNames) {
                try {
                    result.add(AlertType.valueOf((String)valueName));
                }
                catch (EnumIndexOutOfBoundsException e) {
                    logger.warn("Cannot convert value '{}' to PaymentReason. Value ignored.", (Object)valueName);
                }
            }
        }
        return result;
    }
}

