/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.services;

import de.rtb.pcon.core.events.AreaUpdatedEvent;
import de.rtb.pcon.model.AlertType;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.AreaCompany;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmOperationalMode;
import de.rtb.pcon.model.PdmStatus;
import de.rtb.pcon.model.UserRole;
import de.rtb.pcon.model.zone.EnforcementMode;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.repositories.AreaCompanyRepository;
import de.rtb.pcon.repositories.AreaRepository;
import de.rtb.pcon.repositories.PdmHwDevicesRepository;
import de.rtb.pcon.repositories.PdmStatusRepository;
import de.rtb.pcon.repositories.ZoneRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcon.ui.services.SecurityService;
import jakarta.persistence.EntityManager;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class PdmService {
    private static final Logger logger = LoggerFactory.getLogger(PdmService.class);
    private final EntityManager entityManager;
    private final PdmRepository pdmRepo;
    private final AreaRepository areaRepo;
    private final ZoneRepository zoneRepo;
    private final PdmHwDevicesRepository hwDeviceRepo;
    private final SecurityService securityService;
    private final PdmStatusRepository pdmStatusRepo;
    private final AreaCompanyRepository areaCompanyRepo;
    private final ApplicationEventPublisher applicationEventPublisher;

    public PdmService(EntityManager entityManager, PdmRepository pdmRepo, AreaRepository areaRepo, ZoneRepository zoneRepo, PdmHwDevicesRepository hwDeviceRepo, SecurityService securityService, PdmStatusRepository pdmStatusRepo, AreaCompanyRepository areaCompanyRepo, ApplicationEventPublisher applicationEventPublisher) {
        this.entityManager = entityManager;
        this.pdmRepo = pdmRepo;
        this.areaRepo = areaRepo;
        this.zoneRepo = zoneRepo;
        this.hwDeviceRepo = hwDeviceRepo;
        this.securityService = securityService;
        this.pdmStatusRepo = pdmStatusRepo;
        this.areaCompanyRepo = areaCompanyRepo;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pdm createPdm(int pdmNumber, int areaNumber) {
        Area area = this.areaRepo.findById((Object)areaNumber).orElseGet(() -> this.createArea(areaNumber));
        Zone zone = area.getZones().stream().filter(Zone::getIsDefaultZone).findAny().orElseGet(() -> (Zone)area.getZones().get(0));
        Pdm pdm = new Pdm();
        pdm.setNumber(Integer.valueOf(pdmNumber));
        pdm.setName(Integer.toString(pdmNumber));
        pdm.setZone(zone);
        pdm.setOpMode(PdmOperationalMode.ACTIVE);
        this.pdmRepo.save((Object)pdm);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)AreaUpdatedEvent.oneArea((Object)this, (Integer)areaNumber));
        logger.info("New PDM number {} in area {} was automatically created.", (Object)pdmNumber, (Object)areaNumber);
        return pdm;
    }

    @Transactional
    public Area createArea(int number) {
        Area area = new Area();
        area.setId(Integer.valueOf(number));
        area.setName(Integer.toString(number));
        area.setTimeZoneName(ZoneId.systemDefault().getId());
        area = (Area)this.areaRepo.save((Object)area);
        Zone zone = new Zone();
        zone.setArea(area);
        zone.setName(area.getName());
        zone.setColor("#f0f0f0");
        zone.setEnforcementMode(EnforcementMode.DISABLED);
        zone.setIsDefaultZone(Boolean.valueOf(true));
        zone = (Zone)this.zoneRepo.save((Object)zone);
        area.setZones(List.of(zone));
        AreaCompany ac = AreaCompany.createDefault((Area)area);
        this.areaCompanyRepo.save((Object)ac);
        logger.info("New area number {} was automatically created.", (Object)number);
        return area;
    }

    @Transactional(readOnly=true)
    public Optional<Pdm> findPdmByNumberAndCpuId(int pdmNumber, String cpuId) {
        return this.hwDeviceRepo.findPdmByNumberAndCpuId(pdmNumber, cpuId);
    }

    public Map<AlertType, Integer> countPdmsWithIssue() {
        List userAreas = this.securityService.getCurrentAreas();
        boolean canViewAllStatsusMessates = this.securityService.hasRole(UserRole.ROLE_PCON_SUPPORT);
        List statuses = this.pdmStatusRepo.findInAreas((Collection)userAreas, canViewAllStatsusMessates);
        Map<Pdm, AlertType> maxAlertByPdm = statuses.stream().collect(Collectors.groupingBy(PdmStatus::getPdm, Collectors.mapping(s -> s.getMessageConfig().getAlertType(), Collectors.reducing(AlertType.NONE, BinaryOperator.maxBy((a, b) -> a.ordinal() - b.ordinal())))));
        return maxAlertByPdm.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.summingInt(e -> 1)));
    }

    @Transactional
    public List<Pdm> findAndVerifyUserPdms(Collection<Integer> pdmIds) {
        List pdms = pdmIds == null || pdmIds.isEmpty() ? this.entityManager.createQuery("FROM Pdm p JOIN fetch p.area WHERE :user in elements (p.area.users)", Pdm.class).setParameter("user", (Object)this.securityService.getCurrentUser()).getResultList() : this.entityManager.createQuery("FROM Pdm p JOIN fetch p.area WHERE p.id in (:pdmIds) AND :user in elements (p.area.users)", Pdm.class).setParameter("pdmIds", pdmIds).setParameter("user", (Object)this.securityService.getCurrentUser()).getResultList();
        return pdms;
    }

    @Transactional
    public Pdm findAndVerifyUserPdm(int pdmId) {
        HashSet<Integer> pdmIds = new HashSet<Integer>();
        pdmIds.add(pdmId);
        List pdms = this.findAndVerifyUserPdms(pdmIds);
        if (pdms.isEmpty()) {
            return null;
        }
        return (Pdm)pdms.get(0);
    }
}

