/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.pdm;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Stopwatch;
import de.rtb.pcon.core.cash_box.CashBoxMonitorService;
import de.rtb.pcon.core.consts.AppConst;
import de.rtb.pcon.core.events.AreaUpdatedEvent;
import de.rtb.pcon.core.open_messages.OpenMessagesService;
import de.rtb.pcon.core.printer_monitor.PrinterService;
import de.rtb.pcon.core.remote_actions.RemoteActionSevice;
import de.rtb.pcon.core.runtime_monitor.AliveMonitorService;
import de.rtb.pcon.core.runtime_monitor.PdmRuntimeService;
import de.rtb.pcon.features.bonus.utils.JsonUtils;
import de.rtb.pcon.model.AlertType;
import de.rtb.pcon.model.PaperRole;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmHwDevice;
import de.rtb.pcon.model.PdmHwStatus;
import de.rtb.pcon.model.PdmRuntimeMonitor;
import de.rtb.pcon.model.RemoteAction;
import de.rtb.pcon.model.RemoteActionState;
import de.rtb.pcon.model.StatusMessage;
import de.rtb.pcon.model.TariffInfo;
import de.rtb.pcon.model.UserRole;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.download.DownloadEntry;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.repositories.PaymentTransactionRepository;
import de.rtb.pcon.repositories.PdmHwDevicesRepository;
import de.rtb.pcon.repositories.PdmHwStatusRepository;
import de.rtb.pcon.repositories.RtpSessionRepository;
import de.rtb.pcon.repositories.StatusMessageRepository;
import de.rtb.pcon.repositories.ZoneRepository;
import de.rtb.pcon.repositories.fw_update.DownloadEntryRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcon.ui.controllers.EntityNotAvailableException;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.controllers.model.UiChartCollector;
import de.rtb.pcon.ui.controllers.model.UiMoney;
import de.rtb.pcon.ui.controllers.model.UiPdm;
import de.rtb.pcon.ui.controllers.model.UiPdmProperties;
import de.rtb.pcon.ui.controllers.model.UiPdmWithIssue;
import de.rtb.pcon.ui.controllers.model.UiStatusMessage;
import de.rtb.pcon.ui.controllers.pdm.PdmController;
import de.rtb.pcon.ui.controllers.pdm.UiDeleteBlockingIssues;
import de.rtb.pcon.ui.controllers.pdm.UiDeleteBlockingItem;
import de.rtb.pcon.ui.controllers.pdm.UiGeoCoordinates;
import de.rtb.pcon.ui.controllers.pdm.UiPaymentMessage;
import de.rtb.pcon.ui.controllers.pdm.UiPdmConnection;
import de.rtb.pcon.ui.controllers.pdm.UiPdmRuntime;
import de.rtb.pcon.ui.controllers.pdm.UiPdmUpdate;
import de.rtb.pcon.ui.controllers.pdm.UiPrinter;
import de.rtb.pcon.ui.controllers.pdm.UiRemoteAction;
import de.rtb.pcon.ui.controllers.pdm.UiRemoteActionRequest;
import de.rtb.pcon.ui.controllers.pdm.UiRuntimePower;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueReportService;
import de.rtb.pcon.ui.data_tables.DataTableColumn;
import de.rtb.pcon.ui.data_tables.DataTableOrder;
import de.rtb.pcon.ui.data_tables.DataTableResponse;
import de.rtb.pcon.ui.data_tables.StatusRequest;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.DateTimeUtils;
import de.rtb.pcontrol.utils.LoggerUtils;
import de.rtb.pcontrol.utils.StopWatch;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(path={"/api/pcon/ui/pdms"})
class PdmController {
    private static final long REMOTE_ACTION_EXECUTION_TIME = 30L;
    private static final Logger logger = LoggerFactory.getLogger(PdmController.class);
    private static final Logger actionLogger = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions.");
    @PersistenceContext
    private EntityManager entityManager;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final SecurityService securityService;
    private final I18nService i18n;
    private final RevenueReportService revenueReportSerivice;
    private final AliveMonitorService aliveMonitorService;
    private final PrinterService printerService;
    private final RemoteActionSevice remoteActionService;
    private final SecureEntityLoaderService entityLoader;
    private final OpenMessagesService openMessageService;
    private final PaymentTransactionRepository paymentTransactionRepo;
    private final StatusMessageRepository statusMessageRepository;
    private final PdmHwDevicesRepository hwDeviceRepo;
    private final PdmHwStatusRepository hwStatusRepo;
    private final RtpSessionRepository rtpSessionRepo;
    private final PdmRepository pdmRepo;
    private final ZoneRepository zoneRepo;
    private final CashBoxMonitorService cashBoxLevelService;
    private final DownloadEntryRepository downloadEntryRepo;
    private final PdmRuntimeService pdmRuntimeService;
    private final ApplicationEventPublisher applicationEventPublisher;
    private static final String SERVER_TIMING = "Server-Timing";

    public PdmController(EntityManager entityManager, SecurityService securityService, I18nService i18n, RevenueReportService revenueReportSerivice, AliveMonitorService aliveMonitorService, PrinterService printerService, RemoteActionSevice remoteActionService, SecureEntityLoaderService entityLoader, OpenMessagesService openMessageService, PaymentTransactionRepository paymentTransactionRepo, StatusMessageRepository statusMessageRepository, PdmHwDevicesRepository hwDeviceRepo, PdmHwStatusRepository hwStatusRepo, RtpSessionRepository rtpSessionRepo, PdmRepository pdmRepo, ZoneRepository zoneRepo, CashBoxMonitorService cashBoxLevelService, DownloadEntryRepository downloadEntryRepo, PdmRuntimeService pdmRuntimeService, ApplicationEventPublisher applicationEventPublisher) {
        this.entityManager = entityManager;
        this.securityService = securityService;
        this.i18n = i18n;
        this.revenueReportSerivice = revenueReportSerivice;
        this.aliveMonitorService = aliveMonitorService;
        this.printerService = printerService;
        this.remoteActionService = remoteActionService;
        this.entityLoader = entityLoader;
        this.openMessageService = openMessageService;
        this.paymentTransactionRepo = paymentTransactionRepo;
        this.statusMessageRepository = statusMessageRepository;
        this.hwDeviceRepo = hwDeviceRepo;
        this.hwStatusRepo = hwStatusRepo;
        this.rtpSessionRepo = rtpSessionRepo;
        this.pdmRepo = pdmRepo;
        this.zoneRepo = zoneRepo;
        this.cashBoxLevelService = cashBoxLevelService;
        this.downloadEntryRepo = downloadEntryRepo;
        this.pdmRuntimeService = pdmRuntimeService;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @ExceptionHandler(value={EntityNotAvailableException.class})
    public ResponseEntity<String> handleEntityLoadException(EntityNotAvailableException ex) {
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)ex.getHttpStatus());
    }

    @GetMapping(path={"{id}"})
    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public UiPdm getPdm(@PathVariable(value="id") int pdmId) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        return new UiPdm(pdm);
    }

    @DeleteMapping(path={"{id}"})
    @PreAuthorize(value="hasRole('ROLE_PCON_PDM_DELETE')")
    @Transactional
    public UiDeleteBlockingIssues deletePdm(@PathVariable(value="id") int pdmId) {
        List orphanedRtpIds;
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        Zone owningZone = pdm.getZone();
        UiDeleteBlockingIssues result = new UiDeleteBlockingIssues();
        List<UiDeleteBlockingItem> affectedForwardings = pdm.getZone().getArea().getFrowardingRules().stream().filter(r -> Objects.requireNonNullElse(r.getPdmNumbers(), List.of()).contains(pdm.getNumber())).map(UiDeleteBlockingItem::new).toList();
        result.setForwardings(affectedForwardings);
        List<UiDeleteBlockingItem> affectedPlans = this.downloadEntryRepo.planedForPdm(pdm).stream().map(de -> new UiDeleteBlockingItem(de.getPlan())).distinct().toList();
        result.setPlans(affectedPlans);
        if (result.hasIssue()) {
            return result;
        }
        if (logger.isInfoEnabled()) {
            logger.info("The {} will be deleted.", (Object)LoggerUtils.log((Pdm)pdm));
        }
        this.pdmRepo.delete((Object)pdm);
        int deletedRecordsCount = this.entityManager.createQuery("DELETE DownloadPlan dp WHERE (SELECT COUNT(*) FROM DownloadEntry de WHERE de.plan = dp) = 0").executeUpdate();
        if (deletedRecordsCount > 0) {
            logger.debug("Deleted {} orphaned download plans.", (Object)deletedRecordsCount);
        }
        if (!(orphanedRtpIds = this.rtpSessionRepo.findOrphanedIds()).isEmpty() && (deletedRecordsCount = this.rtpSessionRepo.deleteByIdIn((Collection)orphanedRtpIds)) > 0) {
            logger.debug("Deleted {} orphaned RTP sessions.", (Object)deletedRecordsCount);
        }
        logger.debug("The PDM is successfully removed.");
        this.applicationEventPublisher.publishEvent((ApplicationEvent)AreaUpdatedEvent.oneArea((Object)this, (Integer)owningZone.getArea().getId()));
        return result;
    }

    @GetMapping(value={"{id}/properties"})
    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public ResponseEntity<UiPdmProperties> getPdmProperties(@PathVariable(value="id") int pdmId) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        return new ResponseEntity((Object)new UiPdmProperties(pdm), (HttpStatusCode)HttpStatus.OK);
    }

    @PutMapping(value={"{id}/properties"})
    @PreAuthorize(value="hasRole('ROLE_PCON_SERVICE')")
    @Transactional
    public UiPdmProperties setPdmProperties(@PathVariable(value="id") int pdmId, @RequestBody UiPdmProperties uiProperties) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        Zone newZone = (Zone)this.zoneRepo.findById((Object)uiProperties.getParkingZone()).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Zone id " + uiProperties.getParkingZone() + " does not exist."));
        if (!Objects.equals(newZone.getArea(), pdm.getZone().getArea())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Zone " + uiProperties.getParkingZone() + " does not belong to the same Area");
        }
        try {
            UiPdmProperties uiBaseProperties = new UiPdmProperties(pdm);
            String objChanges = LoggerUtils.makeObjectDiff((Object)uiProperties, (Object)uiBaseProperties);
            if (!objChanges.isEmpty()) {
                if (actionLogger.isInfoEnabled()) {
                    actionLogger.info(LoggerUtils.formatObjectDiff((User)this.securityService.getCurrentUser(), (String)LoggerUtils.log((Pdm)pdm), (String)objChanges));
                }
                pdm.setName(uiProperties.getName());
                String phoneNumber = StringUtils.trimToNull((String)uiProperties.getPhoneNumber());
                pdm.setPhoneNumber(phoneNumber);
                pdm.setZone(newZone);
                UiGeoCoordinates geo = this.parseCoordinates(uiProperties.getGeoLocation());
                if (geo != null) {
                    pdm.setLatitude(Double.valueOf(geo.latitude()));
                    pdm.setLongitude(Double.valueOf(geo.longitude()));
                } else {
                    pdm.setLatitude(null);
                    pdm.setLongitude(null);
                }
                pdm.setOpMode(uiProperties.getOpMode());
            }
        }
        catch (RuntimeException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "GEO coordinates culdn't be parsed.", (Throwable)e);
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)AreaUpdatedEvent.oneArea((Object)this, (Integer)pdm.getZone().getArea().getId()));
        return new UiPdmProperties(pdm);
    }

    @GetMapping(value={"{id}/runtime"})
    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public ResponseEntity<UiPdmRuntime> getRuntime(@PathVariable(value="id") int pdmId) {
        StopWatch sw = new StopWatch("pdm/runtime");
        sw.start("Load entity");
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        sw.switchTask("Power report");
        UiPdmRuntime pdmRuntime = new UiPdmRuntime();
        this.pdmRuntimeService.getLastMonitor(pdm).ifPresent(mon -> {
            LocalDateTime time = Optional.ofNullable(mon.getPowerTime()).map(t -> t.toZonedDateTime().withZoneSameInstant(timeZone).toLocalDateTime()).orElse(null);
            pdmRuntime.setPower(new UiRuntimePower(time, mon.getPowerVoltage(), mon.getPowMcsSol(), mon.getPowSvenIn(), mon.getPowSvenBat()));
        });
        if (this.securityService.hasRole(UserRole.ROLE_PCON_ECONOMIST)) {
            sw.switchTask("Cash box");
            List cashBoxLevels = this.cashBoxLevelService.findForPdms(List.of(pdm));
            List<UiMoney> coins = cashBoxLevels.stream().filter(r -> PaymentType.COINS.equals((Object)r.getPaymentType())).map(r -> new UiMoney(r.getLevel(), r.getCurrency())).sorted(Comparator.comparing(UiMoney::getCurrency)).toList();
            pdmRuntime.setCoinValue(coins);
            List<UiMoney> bankNotes = cashBoxLevels.stream().filter(r -> PaymentType.BANK_NOTES.equals((Object)r.getPaymentType())).map(r -> new UiMoney(r.getLevel(), r.getCurrency())).sorted(Comparator.comparing(UiMoney::getCurrency)).toList();
            pdmRuntime.setBanknoteValue(bankNotes);
        }
        sw.stop();
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.ok();
        if (this.securityService.hasRole(UserRole.ROLE_GENERAL_SERVER_MONITOR)) {
            responseBuilder.header(SERVER_TIMING, new String[]{sw.toServerTiming()});
        }
        return responseBuilder.body((Object)pdmRuntime);
    }

    @GetMapping(value={"{id}/connection"})
    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public ResponseEntity<UiPdmConnection> getConnection(@PathVariable(value="id") int pdmId) {
        StopWatch sw = new StopWatch();
        sw.start("Load PDM");
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        sw.switchTask("Runtime info");
        Optional runtimeInfo = this.aliveMonitorService.getRuntimeInfo(pdm);
        sw.stop();
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        UiPdmConnection uiConnection = new UiPdmConnection();
        runtimeInfo.ifPresent(r -> {
            uiConnection.setSignal(r.getNetSignal());
            uiConnection.setNetworkMode(r.getNetType());
            if (r.getNetLogin() != null) {
                uiConnection.setNetworkLogin(DateTimeUtils.toLocalDateTime((OffsetDateTime)r.getNetLogin(), (ZoneId)userTimeZone));
            }
        });
        OffsetDateTime now = OffsetDateTime.now();
        runtimeInfo.map(PdmRuntimeMonitor::getLastKeepAlive).map(t -> (int)Duration.between(t, now).toMinutes()).ifPresent(arg_0 -> ((UiPdmConnection)uiConnection).setKeepAlive(arg_0));
        runtimeInfo.map(PdmRuntimeMonitor::getPayTime).map(t -> (int)Duration.between(t, now).toMinutes()).ifPresent(arg_0 -> ((UiPdmConnection)uiConnection).setPayment(arg_0));
        runtimeInfo.map(PdmRuntimeMonitor::getStaTime).map(t -> (int)Duration.between(t, now).toMinutes()).ifPresent(arg_0 -> ((UiPdmConnection)uiConnection).setStatus(arg_0));
        runtimeInfo.map(PdmRuntimeMonitor::getLastService).map(s -> (int)Duration.between(s, now).toMinutes()).ifPresent(arg_0 -> ((UiPdmConnection)uiConnection).setService(arg_0));
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.ok();
        if (this.securityService.hasRole(UserRole.ROLE_GENERAL_SERVER_MONITOR)) {
            responseBuilder.header(SERVER_TIMING, new String[]{sw.toServerTiming()});
        }
        return responseBuilder.body((Object)uiConnection);
    }

    @GetMapping(value={"{id}/msg/list"})
    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<UiStatusMessage> getOpenMessages(@PathVariable(value="id") int pdmId) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        return this.openMessageService.listUiOpenMessages(List.of(pdm)).values().stream().findAny().orElse(List.of());
    }

    @PostMapping(value={"{id}/msg/solve/{msg}"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<Object> msgSolve(@PathVariable(value="id") int pdmId, @PathVariable(value="msg") short msgNr) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        OpenMessagesService.SolveMessageResult solveResult = this.openMessageService.solveMessage(pdm, msgNr);
        HttpStatus httpStatus = this.solveResultToHttpStatus(solveResult);
        if (HttpStatus.OK.equals((Object)httpStatus) && actionLogger.isInfoEnabled()) {
            actionLogger.info("The {} has confirmed message '{}' for '{}'.", new Object[]{LoggerUtils.log((User)this.securityService.getCurrentUser()), msgNr, LoggerUtils.log((Pdm)pdm)});
        }
        return new ResponseEntity((HttpStatusCode)httpStatus);
    }

    @PostMapping(value={"{id}/msg/acquire/{msg}"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<Object> msgAcquire(@PathVariable(value="id") int pdmId, @PathVariable(value="msg") short msgNr) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        OpenMessagesService.SolveMessageResult solveResult = this.openMessageService.acquireMessage(pdm, msgNr);
        HttpStatus httpStatus = this.solveResultToHttpStatus(solveResult);
        if (HttpStatus.OK.equals((Object)httpStatus) && actionLogger.isInfoEnabled()) {
            actionLogger.info("The {} has acquired message '{}' for '{}'.", new Object[]{LoggerUtils.log((User)this.securityService.getCurrentUser()), msgNr, LoggerUtils.log((Pdm)pdm)});
        }
        return new ResponseEntity((HttpStatusCode)httpStatus);
    }

    @PostMapping(value={"{id}/msg/release/{msg}"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<Object> msgRelease(@PathVariable(value="id") int pdmId, @PathVariable(value="msg") short msgNr) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        OpenMessagesService.SolveMessageResult solveResult = this.openMessageService.releaseMessage(pdm, msgNr);
        HttpStatus httpStatus = this.solveResultToHttpStatus(solveResult);
        if (HttpStatus.OK.equals((Object)httpStatus) && actionLogger.isInfoEnabled()) {
            actionLogger.info("The {} has released message '{}' for '{}'.", new Object[]{LoggerUtils.log((User)this.securityService.getCurrentUser()), msgNr, LoggerUtils.log((Pdm)pdm)});
        }
        return new ResponseEntity((HttpStatusCode)httpStatus);
    }

    private HttpStatus solveResultToHttpStatus(OpenMessagesService.SolveMessageResult solveResult) {
        return switch (2.$SwitchMap$de$rtb$pcon$core$open_messages$OpenMessagesService$SolveMessageResult[solveResult.ordinal()]) {
            case 1 -> HttpStatus.OK;
            case 2 -> HttpStatus.EXPECTATION_FAILED;
            case 3 -> HttpStatus.LOCKED;
            default -> HttpStatus.INTERNAL_SERVER_ERROR;
        };
    }

    @GetMapping(value={"{id}/printer"})
    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public ResponseEntity<UiPrinter> getPrinter(@PathVariable(value="id") int pdmId) {
        LinkedList<String> failureReason = new LinkedList<String>();
        StopWatch sw = new StopWatch("pdm/printer");
        sw.start("PDM load");
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        UiPrinter uiPrinter = new UiPrinter();
        sw.switchTask("Find last paper role");
        Optional lastPaperRoleO = this.printerService.findLastPaperRole(pdm);
        sw.switchTask("Find this paper role");
        Optional thisPaperRoleO = this.printerService.findCurrentPaperRole(pdm);
        sw.stop();
        if (lastPaperRoleO.isPresent()) {
            PaperRole lastPaperRole = (PaperRole)lastPaperRoleO.get();
            PaperRole thisPaperRole = (PaperRole)thisPaperRoleO.orElseThrow();
            sw.start("Processing");
            uiPrinter.setLastPaperChange(this.i18n.toUserLocalDateTime(thisPaperRole.getInTime()));
            uiPrinter.setPrintedTickets((long)thisPaperRole.getTickets());
            double ticketLength = 0.0;
            ticketLength = lastPaperRole.getUsedLength() / (float)lastPaperRole.getTickets();
            double roleDurationInHours = (double)Duration.between(lastPaperRole.getInTime(), lastPaperRole.getOutTime()).getSeconds() / 3600.0;
            double ticketConsumtionPerHour = (double)lastPaperRole.getTickets() / roleDurationInHours;
            double remainingPaper = Math.max(thisPaperRole.getRoleLength() - thisPaperRole.getUsedLength(), 0.0f);
            double remainingTickets = remainingPaper / ticketLength;
            uiPrinter.setRemainingTickets(Long.valueOf((long)remainingTickets));
            uiPrinter.setSupplyInPercent(Integer.valueOf((int)(100.0 * remainingPaper / (double)thisPaperRole.getRoleLength())));
            double paperSupplyInHours = remainingTickets / ticketConsumtionPerHour;
            uiPrinter.setSupplyInDays(Integer.valueOf((int)paperSupplyInHours / 24));
            uiPrinter.setTicketConsumption(Integer.valueOf((int)ticketConsumtionPerHour * 24));
            sw.stop();
        } else {
            failureReason.add("x-no-last-role");
            if (thisPaperRoleO.isPresent()) {
                PaperRole thisPaperRole = (PaperRole)thisPaperRoleO.get();
                sw.start("Processing first role");
                uiPrinter.setLastPaperChange(this.i18n.toUserLocalDateTime(thisPaperRole.getInTime()));
                uiPrinter.setPrintedTickets((long)thisPaperRole.getTickets());
                uiPrinter.setSupplyInPercent(Integer.valueOf((int)(100.0f * ((thisPaperRole.getRoleLength() - thisPaperRole.getUsedLength()) / thisPaperRole.getRoleLength()))));
                sw.stop();
            } else {
                failureReason.add("x-no-this-role");
                sw.start("Processing old FW");
                this.printerService.findLastPaperRoleChangeFromStatusMessages(pdm).ifPresentOrElse(lastPaperRoleChange -> {
                    uiPrinter.setLastPaperChange(this.i18n.toUserLocalDateTime(lastPaperRoleChange));
                    uiPrinter.setPrintedTickets(this.printerService.countPrintedTickets(pdm, lastPaperRoleChange));
                    if (lastPaperRoleChange.isAfter(OffsetDateTime.now())) {
                        failureReason.add("x-last-role-in-future-" + lastPaperRoleChange.toLocalDate().toString());
                    }
                }, () -> failureReason.add("x-no-status-65-in-" + AppConst.LIMIT_PAPER_ROLE_CHANGED.toDays() + "-days"));
                sw.stop();
            }
        }
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.ok();
        if (this.securityService.hasRole(UserRole.ROLE_GENERAL_SERVER_MONITOR)) {
            responseBuilder.header(SERVER_TIMING, new String[]{sw.toServerTiming() + ", " + failureReason.stream().collect(Collectors.joining(", "))});
        }
        return responseBuilder.body((Object)uiPrinter);
    }

    @GetMapping(value={"{id}/revenue"})
    @PreAuthorize(value="hasRole('ROLE_PCON_ECONOMIST')")
    @Transactional(readOnly=true)
    public ResponseEntity<UiChartCollector.ChartData> getIncome(@PathVariable(value="id") int pdmId) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        YearMonth to = YearMonth.now();
        YearMonth from = to.minusMonths(12L);
        Map result = this.revenueReportSerivice.prepareMonthlySummaryByPaymentReasonReport(Set.of(pdm), (Collection)AppConst.REVENUE_PAYMENT_REASONS, from, to);
        DateTimeFormatter ymFormatter = DateTimeFormatter.ofPattern("yyyy/MM");
        UiChartCollector chartData = new UiChartCollector((Object)BigDecimal.ZERO);
        chartData.enforceCategories(IntStream.rangeClosed(0, 11).mapToObj(i -> from.plusMonths(i).format(ymFormatter)).toList());
        for (Map.Entry currencyEntry : result.entrySet()) {
            String currency = (String)currencyEntry.getKey();
            Map data = (Map)currencyEntry.getValue();
            for (Map.Entry dataEntry : data.entrySet()) {
                chartData.addValue(currency, (Object)((YearMonth)dataEntry.getKey()).format(ymFormatter), (Object)((BigDecimal)dataEntry.getValue()));
            }
        }
        return new ResponseEntity((Object)chartData.build(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"{id}/statutes"})
    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public DataTableResponse<UiStatusMessage> getStatusMessages(@PathVariable(value="id") int pdmId, @RequestBody StatusRequest filter, Authentication authentication) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        boolean showAllStatusMessages = UserRole.containsRole((Authentication)authentication, (UserRole)UserRole.ROLE_PCON_SUPPORT);
        DataTableResponse result = new DataTableResponse();
        result.setDraw(filter.getDraw());
        int pageNr = filter.getStart() / filter.getLength();
        int pageLen = filter.getLength();
        LinkedList<Sort.Order> orders = new LinkedList<Sort.Order>();
        for (DataTableOrder dtOrderRule : filter.getOrder()) {
            if ("alert".equals(((DataTableColumn)filter.getColumns().get(dtOrderRule.getColumn())).getName())) {
                if ("asc".equals(dtOrderRule.getDirection())) {
                    orders.add(Sort.Order.by((String)"messageConfig.alertType"));
                } else {
                    orders.add(Sort.Order.desc((String)"messageConfig.alertType"));
                }
            }
            if ("time".equals(((DataTableColumn)filter.getColumns().get(dtOrderRule.getColumn())).getName())) {
                if ("asc".equals(dtOrderRule.getDirection())) {
                    orders.add(Sort.Order.by((String)"pdmTime"));
                    orders.add(Sort.Order.by((String)"id"));
                } else {
                    orders.add(Sort.Order.desc((String)"pdmTime"));
                    orders.add(Sort.Order.desc((String)"id"));
                }
            }
            if (!"number".equals(((DataTableColumn)filter.getColumns().get(dtOrderRule.getColumn())).getName())) continue;
            if ("asc".equals(dtOrderRule.getDirection())) {
                orders.add(Sort.Order.by((String)"messageConfig.number"));
                continue;
            }
            orders.add(Sort.Order.desc((String)"messageConfig.number"));
        }
        PageRequest pageReq = PageRequest.of((int)pageNr, (int)pageLen, (Sort)Sort.by(orders));
        Slice statusSlice = null;
        OffsetDateTime searchStart = OffsetDateTime.now().minus(AppConst.LIMIT_UI_PDM_HISTORY);
        statusSlice = showAllStatusMessages ? this.statusMessageRepository.sliceByPdmWithConfig(pdm, searchStart, (Pageable)pageReq) : this.statusMessageRepository.sliceByPdmWithConfigEssentialOnly(pdm, searchStart, (Pageable)pageReq);
        int totalRecords = filter.getStart() + filter.getLength();
        if (statusSlice.hasNext()) {
            ++totalRecords;
        }
        result.setRecordsTotal((long)totalRecords);
        result.setRecordsFiltered((long)totalRecords);
        LinkedList<UiStatusMessage> statuses = new LinkedList<UiStatusMessage>();
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        for (StatusMessage status : statusSlice) {
            UiStatusMessage sm = new UiStatusMessage();
            sm.setTime(DateTimeUtils.toLocalDateTime((OffsetDateTime)status.getPdmTime(), (ZoneId)userTimeZone));
            sm.setAlert(status.getMessageConfig().getAlertType());
            sm.setNumber((int)status.getMessageConfig().getNumber().shortValue());
            sm.setReason((JsonNode)JsonUtils.readValue((String)status.getReason(), JsonNode.class));
            statuses.add(sm);
        }
        result.setData(statuses);
        return result;
    }

    @PostMapping(value={"{id}/payments"})
    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public ResponseEntity<DataTableResponse<UiPaymentMessage>> getPaymentMessags(@PathVariable(value="id") int pdmId, @RequestBody StatusRequest filter) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        PageRequest pageReq = PageRequest.of((int)(filter.getStart() / filter.getLength()), (int)filter.getLength(), (Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"id.pdmTime")}));
        OffsetDateTime searchFrom = OffsetDateTime.now().minus(AppConst.LIMIT_UI_PDM_HISTORY);
        Slice dbPaymentSlice = this.paymentTransactionRepo.findByIdPdmAndIdPdmTimeAfter(pdm, searchFrom, (Pageable)pageReq);
        DataTableResponse result = new DataTableResponse();
        result.setDraw(filter.getDraw());
        int recordsTotal = filter.getStart() + filter.getLength();
        if (dbPaymentSlice.hasNext()) {
            ++recordsTotal;
        }
        result.setRecordsTotal((long)recordsTotal);
        result.setRecordsFiltered((long)recordsTotal);
        LinkedList<UiPaymentMessage> payments = new LinkedList<UiPaymentMessage>();
        boolean userIsEconomist = this.securityService.hasRole(UserRole.ROLE_PCON_ECONOMIST);
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        for (PaymentTransaction payment : dbPaymentSlice) {
            UiPaymentMessage pm = new UiPaymentMessage();
            pm.setTime(DateTimeUtils.toLocalDateTime((OffsetDateTime)payment.getId().getPdmTime(), (ZoneId)userTimeZone));
            pm.setPaymentType(payment.getPaymentType());
            if (userIsEconomist) {
                BigDecimal amount = payment.getAmount();
                pm.setAmount(amount.toPlainString() + " " + payment.getCurrency());
            } else {
                pm.setAmount(null);
            }
            payments.add(pm);
        }
        result.setData(payments);
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"{id}/components"})
    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public ResponseEntity<Map<String, Map<String, Map<String, Object>>>> getComponents(@PathVariable(value="id") int pdmId) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        List devices = this.hwDeviceRepo.findByPdm(pdm);
        1 jacksonTypeReference = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, Map> result = new HashMap<String, Map>();
        for (PdmHwDevice hwComp : devices) {
            Map deviceMap = result.computeIfAbsent(hwComp.getDeviceName(), n -> new HashMap());
            Map partMap = deviceMap.computeIfAbsent(hwComp.getPart().jsonName(), x -> new HashMap());
            if (hwComp.getProperties() != null) {
                try {
                    HashMap dbJsonData = (HashMap)this.objectMapper.readValue(hwComp.getProperties(), (TypeReference)jacksonTypeReference);
                    partMap.putAll(dbJsonData);
                }
                catch (JsonProcessingException e) {
                    logger.debug("Cannot read properties of device {} of {}", (Object)deviceMap, (Object)LoggerUtils.log((Pdm)pdm));
                }
            }
            partMap.put("name", hwComp.getModel());
            if (Objects.nonNull(hwComp.getVersion()) && !partMap.containsKey("ver")) {
                partMap.put("ver", hwComp.getVersion());
            }
            if (!Objects.nonNull(hwComp.getSerialNumber()) || partMap.containsKey("sn")) continue;
            partMap.put("sn", hwComp.getSerialNumber());
        }
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body(result);
    }

    @GetMapping(value={"{id}/hw-runtime"})
    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public ResponseEntity<String> getHwRuntime(@PathVariable(value="id") int pdmId) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)this.hwStatusRepo.findByPdm(pdm).map(PdmHwStatus::getStatus).orElse("{}"));
    }

    @GetMapping(value={"{id}/tariffs"})
    @Transactional(readOnly=true)
    public List<String> getTariffs(@PathVariable(value="id") int pdmId) {
        return this.entityLoader.loadPdm(pdmId).getTariffInfos().stream().map(TariffInfo::getName).toList();
    }

    @GetMapping(value={"{id}/updates"})
    @Transactional(readOnly=true)
    public List<UiPdmUpdate> getUpdateHistory(@PathVariable(value="id") int pdmId) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        Function<DownloadEntry, OffsetDateTime> timeExtractor = e -> Optional.ofNullable(e.getActivationConfirmation()).or(() -> Optional.ofNullable(e.getDownloadConfirmation())).or(() -> Optional.ofNullable(e.getPlan().getDownloadTime())).orElseGet(() -> OffsetDateTime.MIN);
        return this.downloadEntryRepo.historyForPdm(pdm).stream().sorted(Comparator.comparing(timeExtractor).reversed()).map(de -> new UiPdmUpdate(de, userTimeZone)).toList();
    }

    @GetMapping(value={"{id}/actions"})
    @PreAuthorize(value="hasRole('ROLE_PCON_SERVICE')")
    @Transactional(readOnly=true)
    public ResponseEntity<Collection<UiRemoteAction>> getRemoteActions(@PathVariable(value="id") int pdmId) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        List actions = this.remoteActionService.list(pdm);
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        List<UiRemoteAction> uiActions = actions.stream().map(ra -> new UiRemoteAction(ra, userTimeZone, arg_0 -> ((AliveMonitorService)this.aliveMonitorService).getNextKeepAlive(arg_0))).toList();
        return new ResponseEntity(uiActions, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"{id}/actions"})
    @PreAuthorize(value="hasRole('ROLE_PCON_SERVICE')")
    @Transactional
    public ResponseEntity<UiRemoteAction> postRemoteAction(@PathVariable(value="id") int pdmId, @RequestBody UiRemoteActionRequest actionRequest) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        int currentUserId = this.securityService.getCurrentUser().getId();
        User user = (User)this.entityManager.getReference(User.class, (Object)currentUserId);
        RemoteAction ra = this.remoteActionService.add(pdm, user, actionRequest.getCode(), actionRequest.getParameters());
        UiRemoteAction uiRemoteAction = new UiRemoteAction(ra, this.i18n.userTimeZoneId(), arg_0 -> ((AliveMonitorService)this.aliveMonitorService).getNextKeepAlive(arg_0));
        this.aliveMonitorService.getNextKeepAlive(pdm).ifPresent(nextKeepAlive -> {
            if (nextKeepAlive != null) {
                int nrOfScheduledActions = this.remoteActionService.executionQueueLength(pdm);
                OffsetDateTime expectedExec = nextKeepAlive.plusSeconds((long)nrOfScheduledActions * 30L);
                uiRemoteAction.setExecDate(this.i18n.toUserLocalDateTime(expectedExec));
            }
        });
        if (actionLogger.isInfoEnabled()) {
            actionLogger.info("The {} scheduled remote action {} for {}.", new Object[]{LoggerUtils.log((User)user), ra.getCode(), LoggerUtils.log((Pdm)pdm)});
        }
        return new ResponseEntity((Object)uiRemoteAction, (HttpStatusCode)HttpStatus.CREATED);
    }

    @DeleteMapping(value={"/actions/{id}"})
    @PreAuthorize(value="hasRole('ROLE_PCON_SERVICE')")
    @Transactional
    public ResponseEntity<UiRemoteAction> deleteRemoteAction(@PathVariable(value="id") int actionId) {
        RemoteAction ra = (RemoteAction)this.entityManager.find(RemoteAction.class, (Object)actionId);
        if (ra == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.GONE);
        }
        Pdm pdm = ra.getPdm();
        if (pdm == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (this.securityService.deniedFor(pdm)) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        if (ra.getState() == RemoteActionState.SHEDULED && actionLogger.isInfoEnabled()) {
            actionLogger.info("The {} un-scheduled remote action {} for {}.", new Object[]{LoggerUtils.log((User)ra.getRequester()), ra.getCode(), LoggerUtils.log((Pdm)pdm)});
        }
        this.remoteActionService.remove(ra);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @Transactional(readOnly=true)
    @GetMapping(path={"/issues"})
    public ResponseEntity<Collection<UiPdmWithIssue>> getPdmsWithIssue() {
        StringBuilder serverTimingHeader = new StringBuilder();
        Stopwatch stopWatch = Stopwatch.createStarted();
        List userAreas = this.securityService.getCurrentAreas();
        if (userAreas.isEmpty()) {
            return ResponseEntity.ok().body(Set.of());
        }
        List pdms = this.pdmRepo.findByArea((Collection)userAreas);
        serverTimingHeader.append("entities;dur=" + stopWatch.stop().elapsed(TimeUnit.MILLISECONDS));
        HashMap result = new HashMap();
        stopWatch = Stopwatch.createStarted();
        Map pdmsWithOpenMessages = this.openMessageService.listUiOpenMessages((Collection)pdms);
        pdmsWithOpenMessages.forEach((pdm, stat) -> {
            UiPdmWithIssue uiPdm = new UiPdmWithIssue(pdm);
            uiPdm.setOpenMessages((Collection)stat);
            stat.stream().mapToInt(s -> s.getAlert().ordinal()).reduce(Integer::max).ifPresent(a -> uiPdm.setAlert(AlertType.values()[a]));
            result.put(uiPdm.getId(), uiPdm);
        });
        serverTimingHeader.append(",alerts;dur=" + stopWatch.stop().elapsed(TimeUnit.MILLISECONDS));
        HttpHeaders headers = new HttpHeaders();
        headers.add(SERVER_TIMING, serverTimingHeader.toString());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)result.values().stream().collect(Collectors.toSet()));
    }

    private UiGeoCoordinates parseCoordinates(String uiCoordinates) {
        if (StringUtils.isBlank((CharSequence)uiCoordinates)) {
            return null;
        }
        Pattern pNumber = Pattern.compile("-?\\d+([\\.,]\\d+)?");
        Matcher m = pNumber.matcher(uiCoordinates);
        m.find();
        String sLat = m.group(0);
        m.find();
        String sLon = m.group(0);
        sLat = sLat.replace(',', '.');
        sLon = sLon.replace(',', '.');
        UiGeoCoordinates geo = new UiGeoCoordinates(Double.parseDouble(sLat), Double.parseDouble(sLon));
        if (geo.latitude() < -180.0 || geo.latitude() > 180.0 || geo.longitude() < -180.0 || geo.longitude() > 180.0) {
            throw new RuntimeException("Latitude and longitude has to be in range [-180, 180]. Was " + geo.latitude() + ", " + geo.longitude() + ".");
        }
        return geo;
    }
}

