/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.logbooks;

import de.rtb.pcon.model.MessageConfigDefault_;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.Pdm_;
import de.rtb.pcon.model.StatusMessage;
import de.rtb.pcon.model.StatusMessage_;
import de.rtb.pcon.model.zone.Zone_;
import de.rtb.pcon.ui.controllers.logbooks.LogbookRepositotyUtils;
import de.rtb.pcon.ui.controllers.logbooks.LogbookStatusRepository;
import de.rtb.pcon.ui.controllers.logbooks.SimpleSlice;
import de.rtb.pcon.ui.data_tables.DataTableColumn;
import de.rtb.pcon.ui.data_tables.DataTableOrder;
import de.rtb.pcon.ui.data_tables.LogbookDataTableRequest;
import de.rtb.pcon.ui.data_tables.StatusRequest;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class LogbookStatusRepository {
    @Autowired
    private EntityManager entityManager;

    @Transactional(readOnly=true)
    public SimpleSlice<StatusMessage> findStatus(Collection<Pdm> pdms, StatusRequest filter, boolean allStatusMessages) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(StatusMessage.class);
        Root root = criteriaQuery.from(StatusMessage.class);
        StatusLogbookJoins joins = this.makeJoins(root);
        Predicate predicate = this.makePredicate(criteriaBuilder, root, joins, pdms, filter, allStatusMessages);
        List order = this.makeOrder(criteriaBuilder, root, joins, (LogbookDataTableRequest)filter);
        criteriaQuery.select((Selection)root).where((Expression)predicate).orderBy(order);
        TypedQuery query = this.entityManager.createQuery(criteriaQuery);
        query.setFirstResult(filter.getStart());
        query.setMaxResults(filter.getLength() + 1);
        List result = query.getResultList();
        return new SimpleSlice(result, filter.getLength());
    }

    public Long countStatus(Collection<Pdm> pdms, StatusRequest filter, boolean allStatusMessages) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        Root root = countQuery.from(StatusMessage.class);
        StatusLogbookJoins joins = this.makeJoins(root);
        Predicate predicate = this.makePredicate(criteriaBuilder, root, joins, pdms, filter, allStatusMessages);
        countQuery.select((Selection)criteriaBuilder.count((Expression)root)).where((Expression)predicate);
        return (Long)this.entityManager.createQuery(countQuery).getSingleResult();
    }

    @Transactional(readOnly=true)
    public Stream<StatusMessage> streamStatuses(Collection<Pdm> pdms, StatusRequest filter, boolean allStatusMessages) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(StatusMessage.class);
        Root root = criteriaQuery.from(StatusMessage.class);
        StatusLogbookJoins joins = this.makeJoins(root);
        Predicate predicate = this.makePredicate(criteriaBuilder, root, joins, pdms, filter, allStatusMessages);
        Order order = criteriaBuilder.desc((Expression)root.get(StatusMessage_.pdmTime));
        criteriaQuery.select((Selection)root).where((Expression)predicate).orderBy(new Order[]{order});
        return this.entityManager.createQuery(criteriaQuery).setHint("org.hibernate.fetchSize", (Object)"10000").getResultStream();
    }

    private StatusLogbookJoins makeJoins(Root<StatusMessage> root) {
        Join pdmJoin = root.join(StatusMessage_.pdm, JoinType.INNER);
        Join cfgJoin = root.join(StatusMessage_.messageConfig, JoinType.INNER);
        Join areaJoin = pdmJoin.join(Pdm_.zone, JoinType.INNER).join(Zone_.area, JoinType.INNER);
        return new StatusLogbookJoins(pdmJoin, cfgJoin, areaJoin);
    }

    private Predicate makePredicate(CriteriaBuilder criteriaBuilder, Root<StatusMessage> root, StatusLogbookJoins joins, Collection<Pdm> pdms, StatusRequest filter, boolean allStatusMessages) {
        LinkedList<Predicate> predicateList = new LinkedList<Predicate>();
        predicateList.add(root.get(StatusMessage_.pdm).in(pdms));
        predicateList.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(StatusMessage_.pdmTime), (Comparable)filter.makeOffsetTimeFrom()));
        predicateList.add(criteriaBuilder.lessThan((Expression)root.get(StatusMessage_.pdmTime), (Comparable)filter.makeOffsetTimeTo()));
        if (CollectionUtils.isNotEmpty((Collection)filter.getAlerts())) {
            predicateList.add(joins.msgConfig().get(MessageConfigDefault_.alertType).in((Collection)filter.getAlerts()));
        }
        if (CollectionUtils.isNotEmpty((Collection)filter.getStatusNumbers())) {
            predicateList.add(joins.msgConfig().get(MessageConfigDefault_.number).in((Collection)filter.getStatusNumbers()));
        }
        if (!allStatusMessages) {
            predicateList.add(criteriaBuilder.isTrue((Expression)joins.msgConfig().get(MessageConfigDefault_.essential)));
        }
        return criteriaBuilder.and(predicateList.toArray(new Predicate[0]));
    }

    private List<Order> makeOrder(CriteriaBuilder cb, Root<StatusMessage> root, StatusLogbookJoins joins, LogbookDataTableRequest filter) {
        LinkedList<Order> orders = new LinkedList<Order>();
        for (DataTableOrder dtOrderRule : filter.getOrder()) {
            Path path;
            String fullProperty = ((DataTableColumn)filter.getColumns().get(dtOrderRule.getColumn())).getName();
            String[] propertyParts = StringUtils.split((String)fullProperty, (String)".");
            if (propertyParts.length == 1) {
                path = root.get(propertyParts[0]);
            } else {
                String mainProp = propertyParts[0];
                String subProp = propertyParts[1];
                path = switch (mainProp) {
                    case "pdm" -> joins.pdm().get(subProp);
                    case "cfg" -> joins.msgConfig().get(subProp);
                    case "area" -> joins.area().get(subProp);
                    default -> throw new IllegalArgumentException("Property : " + mainProp + " is not supported for StatusMessage.");
                };
            }
            String direction = dtOrderRule.getDirection();
            orders.add(LogbookRepositotyUtils.createOrderFromString((CriteriaBuilder)cb, (Path)path, (String)direction));
        }
        return orders;
    }
}

