/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers;

import de.rtb.pcon.core.events.AreaUpdatedEvent;
import de.rtb.pcon.core.open_messages.OpenMessagesService;
import de.rtb.pcon.model.AlertType;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.AreaCompany;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.repositories.AreaCompanyRepository;
import de.rtb.pcon.repositories.UserRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcon.ui.controllers.EntityNotAvailableException;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.controllers.model.UiArea;
import de.rtb.pcon.ui.controllers.model.UiAreaCompany;
import de.rtb.pcon.ui.controllers.model.UiAreaGdpr;
import de.rtb.pcon.ui.controllers.model.UiAreaProperties;
import de.rtb.pcon.ui.controllers.model.UiPdm;
import de.rtb.pcon.ui.controllers.model.UiPdmStatus;
import de.rtb.pcon.ui.controllers.model.UiUserFull;
import de.rtb.pcon.ui.controllers.model.UiZone;
import de.rtb.pcon.ui.controllers.model.UiZone2;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/pcon/ui/areas"})
public class AreaController {
    private static final Logger actionLogger = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions.");
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private UserRepository userRepo;
    @Autowired
    private PdmRepository pdmRepo;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private AreaCompanyRepository areaCompanyRepo;
    @Autowired
    private OpenMessagesService openMessagesService;

    @ExceptionHandler(value={EntityNotAvailableException.class})
    public ResponseEntity<String> handleEntityLoadException(EntityNotAvailableException ex) {
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)ex.getHttpStatus());
    }

    @GetMapping(value={""})
    @Transactional(readOnly=true)
    public List<UiArea> getAreas() {
        List allowedAreas = this.securityService.getCurrentAreas();
        if (CollectionUtils.isEmpty((Collection)allowedAreas)) {
            return Collections.emptyList();
        }
        return allowedAreas.stream().map(UiArea::new).toList();
    }

    @GetMapping(value={"{id}"})
    @Transactional(readOnly=true)
    public UiArea getArea(@PathVariable(value="id") int areaId) {
        Area area = this.entityLoader.loadArea(areaId);
        return new UiArea(area);
    }

    @GetMapping(value={"{id}/properties"})
    @Transactional
    public UiAreaProperties getAreaProperties(@PathVariable(value="id") int id) {
        Area area = this.entityLoader.loadArea(id);
        return new UiAreaProperties(area);
    }

    @PreAuthorize(value="hasRole('ROLE_PCON_SERVICE')")
    @PutMapping(value={"{id}/properties"})
    @Transactional
    public void setAreaProperties(@PathVariable(value="id") int id, @RequestBody UiAreaProperties uiAreaProps) {
        Area area = this.entityLoader.loadArea(id);
        UiArea uiAreaBase = new UiArea(area);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)AreaUpdatedEvent.oneArea((Object)this, (Integer)id));
        String objChanges = LoggerUtils.makeObjectDiff((Object)uiAreaProps, (Object)uiAreaBase);
        if (!objChanges.isEmpty()) {
            if (actionLogger.isInfoEnabled()) {
                actionLogger.info(LoggerUtils.formatObjectDiff((User)this.securityService.getCurrentUser(), (String)LoggerUtils.log((Area)area), (String)objChanges));
            }
            area.setName(uiAreaProps.getName());
            area.setTimeZoneName(uiAreaProps.getTimeZone());
            Integer currentDefaultZone = area.getZones().stream().filter(Zone::getIsDefaultZone).findAny().map(Zone::getId).orElse(-1);
            if (!currentDefaultZone.equals(uiAreaProps.getDefaultParkingZone())) {
                area.getZones().forEach(z -> z.setIsDefaultZone(Boolean.valueOf(z.getId().equals(uiAreaProps.getDefaultParkingZone()))));
            }
        }
    }

    @GetMapping(value={"{id}/zones"})
    @Transactional(readOnly=true)
    public Collection<UiZone> getZonesInArea(@PathVariable(value="id") int id) {
        Area area = this.entityLoader.loadArea(id);
        return area.getZones().stream().map(z -> new UiZone(z, true)).collect(Collectors.toSet());
    }

    @PostMapping(value={"{id}/zones"})
    @PreAuthorize(value="hasRole('ROLE_PCON_SERVICE')")
    @Transactional
    public UiZone2 addZone(@PathVariable(value="id") int id, @RequestBody UiZone.Properties uiZone) {
        Area area = this.entityLoader.loadArea(id);
        Zone dbZone = new Zone();
        dbZone.setArea(area);
        dbZone.setName(uiZone.getName());
        dbZone.setDescription(uiZone.getDescription());
        dbZone.setColor(uiZone.getColor());
        dbZone.setEnforcementMode(uiZone.getEnforcementMode());
        dbZone.setIsDefaultZone(Boolean.valueOf(false));
        this.entityManager.persist((Object)dbZone);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)AreaUpdatedEvent.oneArea((Object)this, (Integer)id));
        return new UiZone2(dbZone);
    }

    @GetMapping(value={"{id}/pdms"})
    @Transactional(readOnly=true)
    public Collection<UiPdm> getPdmsInArea(@PathVariable(value="id") int id) {
        Area area = this.entityLoader.loadArea(id);
        return this.pdmRepo.findByArea(area).stream().map(UiPdm::new).collect(Collectors.toSet());
    }

    @GetMapping(value={"{id}/pdms/status"})
    @Transactional(readOnly=true)
    public List<UiPdmStatus> getStatusOfPdmsInArea(@PathVariable(value="id") int id) {
        Area area = this.entityLoader.loadArea(id);
        List pdms = this.pdmRepo.findByArea(area);
        Map openMessages = this.openMessagesService.listUiOpenMessages((Collection)pdms);
        return pdms.stream().map(pdm -> {
            List oms = openMessages.getOrDefault(pdm, List.of());
            AlertType maxAlert = oms.stream().map(s -> s.getAlert()).max(Comparable::compareTo).orElse(AlertType.NONE);
            return new UiPdmStatus(pdm.getId(), maxAlert);
        }).toList();
    }

    @GetMapping(value={"{id}/team"})
    @Transactional(readOnly=true)
    public List<UiUserFull> getTeam(@PathVariable(value="id") int id) {
        Area area = this.entityLoader.loadArea(id);
        return this.userRepo.withRoles((Collection)area.getUsers()).stream().map(UiUserFull::new).toList();
    }

    @GetMapping(value={"{id}/gdpr"})
    public UiAreaGdpr getGdprProperties(@PathVariable(value="id") Integer id) {
        Area area = this.entityLoader.loadArea(id.intValue());
        return new UiAreaGdpr(area.getCleanLpnAfterDays());
    }

    @PutMapping(value={"{id}/gdpr"})
    @Transactional
    public void putGdprProperties(@PathVariable(value="id") Integer id, @RequestBody UiAreaGdpr gdpr) {
        Area area = this.entityLoader.loadArea(id.intValue());
        if (gdpr.cleanLpnAfter() == null) {
            area.setCleanLpnAfterDays(null);
        } else {
            area.setCleanLpnAfterDays(Integer.valueOf(Math.max(1, gdpr.cleanLpnAfter())));
        }
    }

    @GetMapping(value={"{id}/company"})
    @Transactional(readOnly=true)
    public UiAreaCompany areaCompany(@PathVariable Integer id) {
        Area area = this.entityLoader.loadArea(id.intValue());
        AreaCompany areaCompany = this.areaCompanyRepo.findById((Object)area.getId()).orElseGet(() -> AreaCompany.createDefault((Area)area));
        return UiAreaCompany.fromEntity((AreaCompany)areaCompany);
    }

    @PutMapping(value={"{id}/company"})
    public void areaCompany(@PathVariable Integer id, @RequestBody UiAreaCompany c) {
        Area area = this.entityLoader.loadArea(id.intValue());
        AreaCompany areaCompany = this.areaCompanyRepo.findById((Object)area.getId()).orElseGet(() -> AreaCompany.createDefault((Area)area));
        areaCompany.setName(c.name());
        areaCompany.setContact(c.contact());
        areaCompany.setCompanyNumber(c.companyNr());
        areaCompany.setVatNumber(c.vatNr());
        areaCompany.setVatPercent(c.vat());
        this.areaCompanyRepo.save((Object)areaCompany);
    }
}

