/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.model.appmanagement;

import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.msgfw.MessageForwardingRule;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@NamedEntityGraph(name="User.WithRoles", attributeNodes={@NamedAttributeNode(value="roles")})
@Entity
@Table(name="user_authentication", schema="control")
public class User {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="usa_id", nullable=false, unique=true)
    private Integer id;
    @Column(name="usa_enabled", nullable=false)
    private boolean enabled;
    @Column(name="usa_login", nullable=false, unique=true)
    private String login;
    @Column(name="usa_firstname", nullable=false)
    private String firstName;
    @Column(name="usa_lastname", nullable=false)
    private String lastName;
    @Column(name="usa_password", nullable=false, columnDefinition="bpchar")
    private String passwordHash;
    @Column(name="usa_email", nullable=false)
    private String email;
    @ElementCollection
    @CollectionTable(name="user_role", schema="control", joinColumns={@JoinColumn(name="usr_user_id")})
    @Column(name="usr_role")
    private Set<String> roles;
    @Column(name="usa_timezone", length=40)
    private String timeZoneName;
    @ManyToMany
    @JoinTable(name="area_x_user", schema="control", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="area_id")})
    private List<Area> areas;
    @OneToMany(mappedBy="user")
    private List<MessageForwardingRule> msgfwRules;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public String getTimeZoneName() {
        return this.timeZoneName;
    }

    public void setTimeZoneName(String timeZoneName) {
        this.timeZoneName = timeZoneName;
    }

    public List<Area> getAreas() {
        return this.areas;
    }

    public void setAreas(List<Area> areas) {
        this.areas = areas;
    }

    public List<MessageForwardingRule> getMsgfwRules() {
        return this.msgfwRules;
    }

    public void setMsgfwRules(List<MessageForwardingRule> msgfwRules) {
        this.msgfwRules = msgfwRules;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (this.id == null && other.id == null) {
            return false;
        }
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "User [id=" + this.id + ", enabled=" + this.enabled + ", login=" + this.login + ", firstName=" + this.firstName + ", lastName=" + this.lastName + "]";
    }
}

