/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.model;

import de.rtb.pcon.model.NetworkType;
import de.rtb.pcon.model.Pdm;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.OffsetDateTime;
import org.hibernate.annotations.JdbcType;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;

@Entity
@Table(name="modem_login", schema="control")
public class ModemLogin {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="mlg_id", unique=true, nullable=false)
    private Integer id;
    @ManyToOne
    @JoinColumn(name="mlg_pdm_id")
    private Pdm pdm;
    @Column(name="mlg_pdm_time")
    private OffsetDateTime pdmTime;
    @Column(name="mlg_signal", nullable=false)
    private Short signalStrength;
    @Column(name="mlg_net_type", columnDefinition="\"control\".\"network_type\"\n")
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private NetworkType netType;

    public ModemLogin() {
    }

    public ModemLogin(Pdm pdm, OffsetDateTime pdmTime, Short signalStrength, NetworkType netType) {
        this.pdm = pdm;
        this.pdmTime = pdmTime;
        this.signalStrength = signalStrength;
        this.netType = netType;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Pdm getPdm() {
        return this.pdm;
    }

    public void setPdm(Pdm pdm) {
        this.pdm = pdm;
    }

    public OffsetDateTime getPdmTime() {
        return this.pdmTime;
    }

    public void setPdmTime(OffsetDateTime pdmTime) {
        this.pdmTime = pdmTime;
    }

    public Short getSignalStrength() {
        return this.signalStrength;
    }

    public void setSignalStrength(Short signalStrength) {
        this.signalStrength = signalStrength;
    }

    public NetworkType getNetType() {
        return this.netType;
    }

    public void setNetType(NetworkType netType) {
        this.netType = netType;
    }
}

