/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.touchnet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.features.partners.touchnet.OneCardConfigDto;
import de.rtb.pcon.features.partners.touchnet.OneCardConfigService;
import de.rtb.pcon.features.partners.touchnet.OneCardException;
import de.rtb.pcon.features.partners.touchnet.OneCardInquiryResponse;
import de.rtb.pcon.features.partners.touchnet.OneCardLoginResponse;
import de.rtb.pcon.features.partners.touchnet.OneCardLogutResponse;
import de.rtb.pcon.features.partners.touchnet.OneCardPreCancelResponse;
import de.rtb.pcon.features.partners.touchnet.OneCardPreInitResponse;
import de.rtb.pcon.features.partners.touchnet.OneCardResponse;
import de.rtb.pcon.features.partners.touchnet.OneCardTransactionStatusBaseResponse;
import de.rtb.pcon.features.partners.touchnet.OneCardVendMoneyResponse;
import de.rtb.pcon.model.Pdm;
import java.math.BigDecimal;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
class OneCardApiService {
    private static final Logger log = LoggerFactory.getLogger(OneCardApiService.class);
    private static final ParameterizedTypeReference<Map<String, Object>> MAP_RESPONSE_TYPE = new /* Unavailable Anonymous Inner Class!! */;
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;
    private final OneCardConfigService configService;

    public OneCardApiService(@Qualifier(value="rt3rdPartyApi") RestTemplate restTemplate, ObjectMapper objectMapper, OneCardConfigService configService) {
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        this.configService = configService;
    }

    public OneCardLoginResponse login(Pdm pdm, String terminalId) {
        OneCardConfigDto config = (OneCardConfigDto)this.configService.fetchConfig(pdm.getZone().getArea());
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"OperatorID", (Object)config.operatorId());
        body.add((Object)"PIN", (Object)config.operatorPassword());
        body.add((Object)"TerminalID", (Object)terminalId);
        body.add((Object)"TerminalType", (Object)"ThirdParty");
        body.add((Object)"OriginID", (Object)"693");
        return (OneCardLoginResponse)this.exchangeDataWithTouchNet(config, List.of("operator", "login"), (MultiValueMap)body, OneCardLoginResponse.class);
    }

    public OneCardLogutResponse logout(Pdm pdm, String sessionId) {
        OneCardConfigDto config = (OneCardConfigDto)this.configService.fetchConfig(pdm.getZone().getArea());
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"OperatorID", (Object)config.operatorId());
        body.add((Object)"SessionID", (Object)sessionId);
        return (OneCardLogutResponse)this.exchangeDataWithTouchNet(config, List.of("operator", "logout"), (MultiValueMap)body, OneCardLogutResponse.class);
    }

    public OneCardPreInitResponse transPreInit(Pdm pdm, String sessionId) {
        OneCardConfigDto config = (OneCardConfigDto)this.configService.fetchConfig(pdm.getZone().getArea());
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"SessionID", (Object)sessionId);
        return (OneCardPreInitResponse)this.exchangeDataWithTouchNet(config, List.of("transactions", "preinit"), (MultiValueMap)body, OneCardPreInitResponse.class);
    }

    public OneCardPreCancelResponse transPreCancel(Pdm pdm, String sessionId, String oneCardTransID) {
        OneCardConfigDto config = (OneCardConfigDto)this.configService.fetchConfig(pdm.getZone().getArea());
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"SessionID", (Object)sessionId);
        body.add((Object)"OneCardTransID", (Object)oneCardTransID);
        return (OneCardPreCancelResponse)this.exchangeDataWithTouchNet(config, List.of("transactions", "preinitcancel"), (MultiValueMap)body, OneCardPreCancelResponse.class);
    }

    public OneCardInquiryResponse queryBalance(Pdm pdm, String sessionId, Optional<String> oneCardTransID, String accountId, String accountType, Integer transType, Optional<BigDecimal> amount) {
        OneCardConfigDto config = (OneCardConfigDto)this.configService.fetchConfig(pdm.getZone().getArea());
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"SessionID", (Object)sessionId);
        oneCardTransID.ifPresent(arg_0 -> OneCardApiService.lambda$queryBalance$0((MultiValueMap)body, arg_0));
        body.add((Object)"AccountID", (Object)accountId);
        body.add((Object)"AccountType", (Object)accountType);
        body.add((Object)"TranType", (Object)transType.toString());
        amount.ifPresent(arg_0 -> OneCardApiService.lambda$queryBalance$1((MultiValueMap)body, arg_0));
        return (OneCardInquiryResponse)this.exchangeDataWithTouchNet(config, List.of("transactions", "onecard", "inquiry", "process"), (MultiValueMap)body, OneCardInquiryResponse.class);
    }

    public OneCardVendMoneyResponse vendMoney(Pdm pdm, String sessionId, String oneCardTransID, String accountId, String accountType, BigDecimal amount) {
        OneCardConfigDto config = (OneCardConfigDto)this.configService.fetchConfig(pdm.getZone().getArea());
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"SessionID", (Object)sessionId);
        body.add((Object)"OneCardTransID", (Object)oneCardTransID);
        body.add((Object)"AccountID", (Object)accountId);
        body.add((Object)"AccountType", (Object)accountType);
        body.add((Object)"TranType", (Object)"4");
        body.add((Object)"Amount", (Object)amount.toPlainString());
        return (OneCardVendMoneyResponse)this.exchangeDataWithTouchNet(config, List.of("transactions", "onecard", "vendmoney", "process"), (MultiValueMap)body, OneCardVendMoneyResponse.class);
    }

    public OneCardTransactionStatusBaseResponse transactionResult(Pdm pdm, String sessionId, String oneCardTransID) {
        OneCardConfigDto config = (OneCardConfigDto)this.configService.fetchConfig(pdm.getZone().getArea());
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"SessionID", (Object)sessionId);
        body.add((Object)"OneCardTransID", (Object)oneCardTransID);
        return (OneCardTransactionStatusBaseResponse)this.exchangeDataWithTouchNet(config, List.of("transactions", "get"), (MultiValueMap)body, OneCardTransactionStatusBaseResponse.class);
    }

    <T extends OneCardResponse> T exchangeDataWithTouchNet(OneCardConfigDto config, List<String> pathSegments, MultiValueMap<String, String> reqBody, Class<T> clazz) {
        URI reqUri = UriComponentsBuilder.fromUriString((String)config.baseUrl()).pathSegment(pathSegments.toArray(new String[0])).build().encode().toUri();
        RequestEntity reqEntity = ((RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)RequestEntity.post((URI)reqUri).accept(new MediaType[]{MediaType.APPLICATION_JSON})).header("DevKey", new String[]{"d0ad3ffa0f7c604521087cc0a40da8c4"})).contentType(MediaType.APPLICATION_FORM_URLENCODED).body(reqBody);
        log.atTrace().setMessage("Request to OneCard: {}").addArgument((Object)this.objectToJsonString(reqEntity.getBody())).log();
        ResponseEntity responseEntity = this.restTemplate.exchange(reqEntity, MAP_RESPONSE_TYPE);
        Map body = (Map)responseEntity.getBody();
        log.atTrace().setMessage("Response from OneCard: {}").addArgument((Object)this.objectToJsonString((Object)body)).log();
        if (body == null) {
            throw OneCardException.emptyBody();
        }
        OneCardResponse baseResponse = (OneCardResponse)this.objectMapper.convertValue((Object)body, OneCardResponse.class);
        if (Objects.equals("OK", baseResponse.getStatus())) {
            return (T)((OneCardResponse)this.objectMapper.convertValue((Object)body, clazz));
        }
        String errorCode = baseResponse.getResponseStatus().getErrorCode();
        String message = baseResponse.getResponseStatus().getMessage();
        throw new OneCardException(message, Integer.valueOf(Integer.parseInt(errorCode)));
    }

    private String objectToJsonString(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.error("Cannot serialize one card response", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void lambda$queryBalance$1(MultiValueMap body, BigDecimal a) {
        body.add((Object)"Amount", (Object)a.toPlainString());
    }

    private static /* synthetic */ void lambda$queryBalance$0(MultiValueMap body, String o) {
        body.add((Object)"OneCardTransID", (Object)o);
    }
}

