/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.rao;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.rao.RaoConfigDto;
import de.rtb.pcon.features.partners.rao.RaoConfigService;
import de.rtb.pcon.features.partners.rao.RaoProperties;
import de.rtb.pcon.features.partners.rao.model.PdmInitSaleResponse;
import de.rtb.pcon.features.partners.rao.model.RaoInitSaleRequest;
import de.rtb.pcon.features.partners.rao.model.RaoInitSaleResponse;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import java.net.URI;
import java.time.ZoneId;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class RaoRtrInitSale
implements RealTimeRequest {
    private final RestClient restClient;
    private final RaoConfigService raoConfigService;
    private final RaoProperties raoProps;

    RaoRtrInitSale(@Qualifier(value="wc3rdPartyApi") RestClient restClient, RaoConfigService raoConfigService, RaoProperties raoProps) {
        this.restClient = restClient;
        this.raoConfigService = raoConfigService;
        this.raoProps = raoProps;
    }

    public int getId() {
        return 55;
    }

    public String getDescription() {
        return "RAO, init sale";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        RaoConfigDto config = (RaoConfigDto)this.raoConfigService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        Pdm pdm = ctx.findPdmEntity();
        ZoneId pdmTimeZone = ZoneId.of(pdm.getZone().getArea().getTimeZoneName());
        RaoInitSaleRequest initSaleRequest = (RaoInitSaleRequest)ctx.getLocalObject("body", RaoInitSaleRequest.class);
        initSaleRequest = new RaoInitSaleRequest(initSaleRequest.companyId(), initSaleRequest.articleId(), config.reseller(), initSaleRequest.quantity(), initSaleRequest.lpn(), initSaleRequest.transactionId(), initSaleRequest.penaltyNumber(), ctx.global().getDatTim(), initSaleRequest.begin());
        try {
            URI uri = UriComponentsBuilder.fromUriString((String)this.raoProps.getUrl()).pathSegment(new String[]{"api", "rao", "sale", "init"}).build().toUri();
            RaoInitSaleResponse initSateResponse = (RaoInitSaleResponse)((RestClient.RequestBodySpec)this.restClient.post().uri(uri)).body((Object)initSaleRequest).retrieve().body(RaoInitSaleResponse.class);
            return Map.of("httpStatus", 200, "body", PdmInitSaleResponse.fromRao((RaoInitSaleResponse)initSateResponse, (ZoneId)pdmTimeZone));
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (ResourceAccessException e) {
            return Map.of("ERC", 3, "ERM", "Cannot access Applejack API.");
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
    }
}

