/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.pagopa;

import de.rtb.pcon.features.partners.PartnerConfiguration;
import de.rtb.pcon.features.partners.PartnerConfigurationService;
import de.rtb.pcon.features.partners.pagopa.PagoPaConfigDto;
import de.rtb.pcon.features.partners.pagopa.PagoPaConfigService;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/pcon/ui/areas/{id}/partners/pago-pa/"})
class PagoPaController {
    private final PagoPaConfigService cfgService;
    private final SecureEntityLoaderService entityLoader;

    public PagoPaController(PagoPaConfigService cfgService, PartnerConfigurationService partnerCfgService, SecureEntityLoaderService entityLoader) {
        this.cfgService = cfgService;
        this.entityLoader = entityLoader;
    }

    @GetMapping(value={"config"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional(readOnly=true)
    public PagoPaConfigDto getConfig(@PathVariable int id) {
        Area area = this.entityLoader.loadArea(id);
        return (PagoPaConfigDto)this.cfgService.fetchConfig(area);
    }

    @GetMapping(value={"validate-prefix/{prefix}"})
    public Object validatePrefix(@PathVariable(name="id") int areaId, @PathVariable(required=true) int prefix) {
        Area area = this.entityLoader.loadArea(areaId);
        return Map.of("available", this.cfgService.isPrevixUnique(area, prefix));
    }

    @PostMapping(value={"config"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional
    public void setConfig(@PathVariable int id, @RequestBody PagoPaConfigDto config) {
        Area area = this.entityLoader.loadArea(id);
        if (!this.cfgService.isPrevixUnique(area, config.totemPrefix().intValue())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "TOTEM prefix '" + config.totemPrefix() + "' is already taken.");
        }
        PagoPaConfigDto validatedConfig = new PagoPaConfigDto(config.enabled(), config.apiUrl(), config.apiUser(), config.apiPassword(), config.totemPrefix(), config.payerFirstName(), config.payerLastName(), config.payerEmail());
        this.cfgService.updateConfig(area, (PartnerConfiguration)validatedConfig);
    }
}

