/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.hks;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.hks.HksConfigDto;
import de.rtb.pcon.features.partners.hks.HksConfigService;
import de.rtb.pcon.features.partners.hks.HksRtrCatalog;
import de.rtb.pcon.features.partners.hks.HksUtils;
import de.rtb.pcon.model.Area;
import java.net.URI;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class HksRtrCatalog
implements RealTimeRequest {
    private final RestClient restClient;
    private final HksConfigService hksConfigService;

    public HksRtrCatalog(@Qualifier(value="wc3rdPartyApi") RestClient restClient, HksConfigService hksConfigService) {
        this.restClient = restClient;
        this.hksConfigService = hksConfigService;
    }

    public int getId() {
        return 38;
    }

    public String getDescription() {
        return "HKS, catalog";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        HksConfigDto config = (HksConfigDto)this.hksConfigService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        URI catalogUri = UriComponentsBuilder.fromUriString((String)config.baseUrl()).pathSegment(new String[]{"catalog"}).build().toUri();
        try {
            ResponseEntity responseEntity = this.restClient.get().uri(catalogUri).header("Authorization", new String[]{HksUtils.basicAuthHeaderContent((HksConfigDto)config)}).header("Accept", new String[]{"application/json, application/xml, text/xml, application/*+json, application/*+xml"}).retrieve().toEntity(DtoHksCatalogResp.class);
            return Map.of("httpStatus", responseEntity.getStatusCode().value(), "body", responseEntity.getBody());
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
    }
}

