/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.brain_behind;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.features.partners.brain_behind.AccountBrbDto;
import de.rtb.pcon.features.partners.brain_behind.AccountPurpose;
import java.util.Collection;
import java.util.Set;

record AccountPdmDto(Set<AccountPurpose> cfg, @JsonProperty(value="bet") int value, @JsonProperty(value="wkz") String currency) {
    private final Set<AccountPurpose> cfg;
    @JsonProperty(value="bet")
    private final int value;
    @JsonProperty(value="wkz")
    private final String currency;

    AccountPdmDto(Set<AccountPurpose> cfg, @JsonProperty(value="bet") int value, @JsonProperty(value="wkz") String currency) {
        this.cfg = cfg;
        this.value = value;
        this.currency = currency;
    }

    public static AccountPdmDto of(AccountBrbDto src, int scale) {
        int value = src.value().scaleByPowerOfTen(scale).intValueExact();
        return new AccountPdmDto(src.purpose(), value, src.currency());
    }

    @JsonGetter(value="cfg")
    public Collection<Integer> getCfgJson() {
        return this.cfg.stream().map(AccountPurpose::getValue).sorted().toList();
    }

    public Set<AccountPurpose> cfg() {
        return this.cfg;
    }

    @JsonProperty(value="bet")
    public int value() {
        return this.value;
    }

    @JsonProperty(value="wkz")
    public String currency() {
        return this.currency;
    }
}

