/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.gates;

import de.rtb.pcon.core.integration.PdmMessageProcessingException;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.gates.PresentTicketRepository;
import de.rtb.pcon.model.zone.Zone;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
class BonGateRtrCount
implements RealTimeRequest {
    @Autowired
    private PresentTicketRepository repo;

    BonGateRtrCount() {
    }

    public int getId() {
        return 35;
    }

    public String getDescription() {
        return "Gate, count tickets";
    }

    @Transactional
    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Zone zone = ctx.global().getPdm().getZone();
        if (zone == null) {
            throw new PdmMessageProcessingException("PDM must be in zone.");
        }
        int count = this.repo.countByZone(zone);
        return Map.of("count", count);
    }
}

