/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.basic.common;

import de.rtb.pcon.features.bonus.AppliedBonus;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;

public class UiGivenBonus {
    private String lpn;
    private LocalDateTime from;
    private LocalDateTime to;
    private long parkingTime;
    private long bonusTime;

    public UiGivenBonus() {
    }

    public UiGivenBonus(String lpn, LocalDateTime from, LocalDateTime to, Duration parkingTime, Duration bonusTime) {
        this.lpn = lpn;
        this.from = from;
        this.to = to;
        this.parkingTime = parkingTime != null ? parkingTime.toMinutes() : 0L;
        this.bonusTime = bonusTime != null ? bonusTime.toMinutes() : 0L;
    }

    public UiGivenBonus(AppliedBonus bonus, ZoneId userTimeZone, boolean protectGdprFields) {
        PaymentTransaction p = bonus.getPayment();
        this.lpn = protectGdprFields ? "" : p.getLpn();
        this.from = DateTimeUtils.toLocalDateTime((OffsetDateTime)p.getId().getPdmTime(), (ZoneId)userTimeZone);
        this.to = DateTimeUtils.toLocalDateTime((OffsetDateTime)p.getParkEndTime(), (ZoneId)userTimeZone);
        this.parkingTime = Duration.between(this.from.truncatedTo(ChronoUnit.MINUTES), this.to).toMinutes();
        this.bonusTime = bonus.getDuration().toMinutes();
    }

    public String getLpn() {
        return this.lpn;
    }

    public void setLpn(String lpn) {
        this.lpn = lpn;
    }

    public LocalDateTime getFrom() {
        return this.from;
    }

    public void setFrom(LocalDateTime from) {
        this.from = from;
    }

    public LocalDateTime getTo() {
        return this.to;
    }

    public void setTo(LocalDateTime to) {
        this.to = to;
    }

    public long getParkingTime() {
        return this.parkingTime;
    }

    public void setParkingTime(long parkingTime) {
        this.parkingTime = parkingTime;
    }

    public long getBonusTime() {
        return this.bonusTime;
    }

    public void setBonusTime(long bonusTime) {
        this.bonusTime = bonusTime;
    }
}

