/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.open_messages;

import de.rtb.pcon.core.open_messages.OpenMessagesService;
import de.rtb.pcon.model.MessageConfigDefault;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmStatus;
import de.rtb.pcon.model.UserRole;
import de.rtb.pcon.repositories.PdmStatusRepository;
import de.rtb.pcon.ui.controllers.model.UiStatusMessage;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpenMessagesService {
    private final SecurityService securityService;
    private final I18nService i18n;
    private final PdmStatusRepository pdmStatusRepo;

    public OpenMessagesService(SecurityService securityService, I18nService i18n, PdmStatusRepository pdmStatusRepo) {
        this.securityService = securityService;
        this.i18n = i18n;
        this.pdmStatusRepo = pdmStatusRepo;
    }

    public Map<Pdm, List<UiStatusMessage>> listUiOpenMessages(Collection<Pdm> pdms) {
        boolean canConfirmAllStatusees = this.securityService.hasRole(UserRole.ROLE_PCON_CONFIRM_STATUS);
        boolean showAllStatusMessages = this.securityService.hasRole(UserRole.ROLE_PCON_SUPPORT);
        List openMessages = this.pdmStatusRepo.findOpenStatusMessages(pdms, showAllStatusMessages);
        HashMap<Pdm, List<UiStatusMessage>> result = new HashMap<Pdm, List<UiStatusMessage>>();
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        for (PdmStatusRepository.PdmStatusWithUserConfig om : openMessages) {
            List omSet = result.computeIfAbsent(om.status().getPdm(), p -> new LinkedList());
            UiStatusMessage uiOm = new UiStatusMessage(om.status(), om.userConfig(), userTimeZone);
            if (canConfirmAllStatusees) {
                uiOm.setManual(true);
            }
            omSet.add(uiOm);
        }
        return result;
    }

    @Transactional
    public SolveMessageResult solveMessage(Pdm pdm, short msgNr) {
        boolean showAllStatusMessages = this.securityService.hasRole(UserRole.ROLE_PCON_SUPPORT);
        List openMessageList = this.pdmStatusRepo.findOpenStatusMessages(List.of(pdm), showAllStatusMessages);
        if (CollectionUtils.isEmpty((Collection)openMessageList)) {
            return SolveMessageResult.NOT_OPEN;
        }
        Optional<PdmStatusRepository.PdmStatusWithUserConfig> omo = openMessageList.stream().filter(t -> {
            MessageConfigDefault mcd = t.defaultConfig();
            return mcd.getNumber() == msgNr;
        }).findFirst();
        if (!omo.isPresent()) {
            return SolveMessageResult.NOT_OPEN;
        }
        PdmStatusRepository.PdmStatusWithUserConfig om = omo.get();
        boolean canBeSolved = this.securityService.hasRole(UserRole.ROLE_PCON_CONFIRM_STATUS);
        if (!canBeSolved) {
            canBeSolved = om.userConfig() == null ? om.defaultConfig().isManual() : om.userConfig().isManual();
        }
        if (!canBeSolved) {
            return SolveMessageResult.LOCKED;
        }
        this.pdmStatusRepo.delete((Object)om.status());
        return SolveMessageResult.DONE;
    }

    @Transactional
    public SolveMessageResult acquireMessage(Pdm pdm, short msgNr) {
        Optional ms = this.pdmStatusRepo.findByPdmAndMessageConfigNumber(pdm, msgNr);
        if (ms.isPresent()) {
            ((PdmStatus)ms.get()).setAcquirer(this.securityService.getCurrentUser());
            return SolveMessageResult.DONE;
        }
        return SolveMessageResult.NOT_OPEN;
    }

    @Transactional
    public SolveMessageResult releaseMessage(Pdm pdm, short msgNr) {
        Optional ms = this.pdmStatusRepo.findByPdmAndMessageConfigNumber(pdm, msgNr);
        if (ms.isPresent()) {
            ((PdmStatus)ms.get()).setAcquirer(null);
            return SolveMessageResult.DONE;
        }
        return SolveMessageResult.NOT_OPEN;
    }
}

