/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import de.rtb.pcon.core.events.AreaDeletedEvent;
import de.rtb.pcon.core.services.pdm_in.ScalableResourcesConfigurationService;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
public class CacheConfig {
    private static final Logger log = LoggerFactory.getLogger(CacheConfig.class);
    public static final String APP_CACHE_REGION_TRACER_GUARD = "tracer-guard";
    public static final String APP_CACHE_REGION_FWD_RULES = "fwd-rules";
    public static final String APP_CACHE_REGION_AREA_PARTNER = "area-partner";
    private CacheManager cacheManager;
    @Autowired
    private ScalableResourcesConfigurationService resCfg;

    @Bean
    CacheManager cacheManager() {
        SimpleCacheManager simpleCacheManager = new SimpleCacheManager();
        simpleCacheManager.setCaches(List.of(this.buildTrcCache(), this.buildMessageForwardingRulesCache(), this.buildPartnerConfiguration()));
        this.cacheManager = simpleCacheManager;
        return simpleCacheManager;
    }

    private CaffeineCache buildTrcCache() {
        return new CaffeineCache(APP_CACHE_REGION_TRACER_GUARD, Caffeine.newBuilder().initialCapacity(this.resCfg.crTracerGuardInit).maximumSize((long)this.resCfg.crTracerGuardMax).expireAfterWrite(Duration.ofDays(1L)).recordStats().build());
    }

    private CaffeineCache buildMessageForwardingRulesCache() {
        return new CaffeineCache(APP_CACHE_REGION_FWD_RULES, Caffeine.newBuilder().initialCapacity(this.resCfg.crFwdRulesInit).maximumSize((long)this.resCfg.crFwdRulesMax).expireAfterWrite(Duration.ofHours(1L)).recordStats().build());
    }

    private CaffeineCache buildPartnerConfiguration() {
        return new CaffeineCache(APP_CACHE_REGION_AREA_PARTNER, Caffeine.newBuilder().initialCapacity(this.resCfg.crAreaPartnersInit).maximumSize((long)this.resCfg.crAreaPartnersMax).expireAfterAccess(Duration.ofDays(7L)).recordStats().build());
    }

    @EventListener
    public void onApplicationEvent(AreaDeletedEvent event) {
        log.info("Evicting forwarding rule cache, because Area {} was deleted.", (Object)event.getAreaId());
        Optional.ofNullable(this.cacheManager.getCache(APP_CACHE_REGION_FWD_RULES)).ifPresent(Cache::clear);
        log.info("Evicting partner configuration cache, because Area {} was deleted.", (Object)event.getAreaId());
        Optional.ofNullable(this.cacheManager.getCache(APP_CACHE_REGION_AREA_PARTNER)).ifPresent(Cache::clear);
    }
}

